#/usr/bin/python3
#coding: utf-8


import re, regex
import codecs
from collections import defaultdict
import operator
import json
import itertools
import subprocess
import time
import test as sp


# reec_stanford = {
# 	"ROOT" : "SENT",
# 	"SENT" : "((PP )?NP VN ([NP|Vinf] )? PUNC)|Vinf|NP|PP PUNC|NP NP VN PUNC|NP Ssub PUNC",
# 	"PP" : "P NP",
# 	"NP" : "((DET )?NC( [AP|MWP|PP])?)|(DET MWN)|NPP|MWN PP|DET ADJ NC PP|MWN|PRO",
# 	"VN" : "([CLS V|VN] )?VPP|CLO V|CLS V",
# 	"Vinf" : "VN PP",
# 	"AP" : "(ADV )* ADJ",
# 	"PUNC"	: "",
# 	"MWP" : "",
# 	"MWN" : "N",
# 	"Sint" : "VN",
# 	"Ssub" : "NP CS NP VN",
# 	"Srel" : "NP( NP)? VN"
# }

def is_unitaire(syntagme):
	"""
		Vérifier si un syntagme est unitaire (format de l'output de Stanford).
		- prend en entrée : le syntagme au format mentionné
		- renvoit en sortie : 'True' si le syntagme est unitaire, 'False' sinon

	"""
	pat = "\([A-Z]+([a-z]+)?\s\w+\)$"
	m = re.match(pat,syntagme)
	if m:
		return True
	else:
		return False

def stanford_lexparse(string):
	"""
		Analyser en constituants une phrase (/ un texte) avec l'analyseur de Stanford.
		- prend en entrée : la phrase (/le texte)
		- renvoit en sortie : le texte étiqueté en constituants

	"""
	string = bytes(string, "utf-8")
	# sh ./lexparser.sh data/testsent.txt
	p = subprocess.Popen(["java","-Xmx2g","-cp","/home/gu/Téléchargements/stanford-parser-full-2017-06-09/*:",
		"edu.stanford.nlp.parser.lexparser.LexicalizedParser",
		"/home/gu/Téléchargements/stanford-french-corenlp-2017-06-09-models/edu/stanford/nlp/models/lexparser/frenchFactored.ser.gz","-"],

		stdin=subprocess.PIPE,stdout=subprocess.PIPE)
	parse_stdout = p.communicate(input=string)[0]
	return parse_stdout.decode("utf-8").strip()

def separer_phrases(output):
	"""
		Séparer les phrases dans l'output du parseur de Stanford.
		- prend en entrée : l'output du parser
		- renvoit en sortie : une liste de phrases parsées.
	"""
	sents, tmp = [],[]
	output = output.split("\n")
	for rel in output[:-1]:
		if rel != "":
			# print(rel,"yy")
			tmp.append(rel)
		else:
			# print("---")
			sents.append(tmp)
			tmp = []
	tmp.append(output[-1])
	sents.append(tmp)
	return sents

def parenthetic_contents(string):
	"""
		Découper une chaîne en fonction du niveau d'enchâssement dans les parenthèses.
		Ex. de chaîne à traiter : '(NP (D le) (N chat))'
		- prend en entrée : la chaîne à découper
		- renvoit en sortie : le découpage au fur et à mesure (transformer cet
		output en list pour qu'il soit exploitable)

	"""
	stack = []
	for i, c in enumerate(string):
		if c == '(':
			stack.append(i)
		elif c == ')' and stack:
			start = stack.pop()
			yield (len(stack), string[start + 1: i])

phrases_test = ["Ce n'est pas avec la branche qu'on fait des boulettes    . ",
"Avez-vous entendu parler de ces mites qui courent sur les biches ? ",
"Appréciez le tout de mon cru. ",
"Avoir des cheveux ne vous empêche pas de nier. ",
"Bernard Pivot en a vu défiler des bouquins sur la deux. ",
"Beethoven détestait les sons courts. ",
"Allons ma fille essuie la vite et bien. ",
"À Wimbledon le juge de touche s'est fait acculer derrière Sanchez. ",
"A vouloir aller plus vite que le son vous risquez de vous briser la nuque. ",
"En voyant les nippons la Chine se souleva. ",
"Ce couvent de femmes a été fondé par les Saluces. ",
"Apprendre à calculer en cent leçons. ",
"Ce gant m'empêche de broder! ",
"Boude pas c'est pas ton genre ! ",
"Admirez donc l'écaille de ces moules ! ",
"Ici on peut voir un vieux plan de Gap. ",
"Achète que je rie ! ",
"Allons les filles ne cousez pas les robes ! ",
"Ce pignon a royale mine. ",
"Auberge de Vendée. ",
"Ça pue dans le car. ",
"Visiter le salon des vins ? ",
"Ce jeune homme a la mine piteuse. ",
"Que j'envie votre brasse ! ",
"Au Zambèze les filles sont belles et gentilles. ",
"A quoi bon me pousser pour que je vous trompe? ",
"Ce beau maillot excitait les foules. ",
"Ce qui me plaît quand je dîne est la purée. ",
"Adélaïde rue de La Paix. ",
"Dans ce clip il aime les sons. ",
"Vous chantez quand je vous laisse ? ",
"Assez de disputes tendues ! ",
"A l'Armée le lieutenant veut défiler et le général m'engueule. ",
"Ce camp a été victime d'un coup de semonce. ",
"Brigitte aime les vertes plages. ",
"Adjudant faites bisser l'appel ! ",
"Avez vous vu le bond de la crue. ",
"Après de pareils faits vous pouvez vous permettre  . ",
"Ah ma soeur vous avez bêché trois allées ! ",
"En voyant la Chine la jeune fille est envahie par une étrange pâleur. ",
"Après un apéritif les penseurs aiment diner. ",
"Ce que votre plante me fait ! ",
"Attention aux pannes de micro ! ",
"Aimer le blanc est une histoire de goût. ",
"Ca sent la frite de Malbat !",
"Madame ce que votre plante me fait !",
"Ici on peut voir un vieux plan de Gap.",
"La route des vins.",
"Le sac des lapins.",
"Vous avez le choix dans la date.",
"Après une fluxion elle a perdu sa soeur.",
"Mouiller les fiches.",
"Le fond de la colle.",
"Aimer le blanc est une histoire de goût.",
"Beethoven détestait les sons courts.",
"Un art de décaler les sons.",
"En voyant les nippons la Chine se souleva.",
"Avez vous vu le bond de la crue ?",
"Couper les nouilles au sécateur.",
"Glisser dans la piscine."]

def extract_reecritures(liste_phrases):
	"""
		Extraire l'ensemble des structures d'enchâssements dans un texte et en déduire les règles de réécritures.
		- prend en entrée : une liste de phrases
		- renvoit en sortie : un dictionnaire des réécritures possibles.
	"""
	texte = "\n".join(liste_phrases)
	texte_parse = stanford_lexparse(texte)
	phrases_parsees = separer_phrases(texte_parse)
	reecritures = defaultdict(list)
	for pp in phrases_parsees:
		pp = " ".join(pp)
		pp = re.sub("\s+"," ",pp)
		synt_pp = list(parenthetic_contents(pp))
		for synt in synt_pp:
			if is_unitaire( "("+synt[1]+")") == True:
				continue
			else:
				c_parent = cigle = synt[1].split()[0]
				# print("\n",synt[1])
				deps = [dep[1] for dep in list(parenthetic_contents(synt[1])) if dep[0]== 0]
				c_enfants = [d.split()[0] for d in deps]
				if c_enfants not in reecritures[c_parent]:
					reecritures[c_parent].append(c_enfants)
	return reecritures



regles_reec = extract_reecritures(phrases_test)

with open('reec_stanford.txt', 'w') as f:
    json.dump(regles_reec, f)


def check_reec(phrase,regles):
	"""
		Vérifier que la structure d'enchâssements d'une phrase est correcte par rapport à
		un ensemble de règles de réécritures.
		- prend en entrée : la phrase à tester et les règles de réécriture
		- renvoit en sortie : 'True' si la structure est correcte / connue, 'False' sinon 

	"""
	phrase_parsee = stanford_lexparse(phrase)
	pp = re.sub("\n","",phrase_parsee)
	pp = re.sub("\s+"," ",pp)
	synt_pp = list(parenthetic_contents(pp))
	for synt in synt_pp:
		if is_unitaire( "("+synt[1]+")") == True:
			continue
		else:
			c_parent = synt[1].split()[0]
			# print("\n",synt[1])
			deps = [dep[1] for dep in list(parenthetic_contents(synt[1])) if dep[0]== 0]
			c_enfants = [d.split()[0] for d in deps]
			if c_enfants in regles[c_parent]:
				return True
			else:
				return False


# print(check_reec("Le sac des lapins.",regles_reec))