#/usr/bin/python3
#coding: utf-8


"""
Vérification sémantique du caractère grivois des candidats.

"""


import codecs,re
import subprocess
from collections import defaultdict





# mots du corpus pour lesquels la connotation grivoise n'est pas ambigue
lexique_griv = ["anus","bitter","branlette","chier","chieuse",
"con","couille","cul","ébat","enculer","faire mettre","foutre",
"merde","nichon","nichons","peloter","pénis","pet","phallus","pine","piner",
"pissé","pisser","prout","putain","pute","rut","salaud","salop",
"sein","seins","trousser","vagin","vagins","vaginal","verge","vît","vulve","zob"]

# mots du corpus pour lesquels la connotation grivoise est ambigue
lexique_ambig = ["baiser","bander","bite",
"boudin","bout","bouts","branler","brouter","chatte","crottes",
"dard","doigt","enfiler","fente","fesse","gland","lardon","lécher",
"membre","miche","monté","motte","mouiller","moule",
"noeud","pomper","queue","raie","semence","trou"]



def stanford_nnparse(string):
	""" Parser des chaînes de caractères avec le parseur réseau de neurones de Stanford.
	- en entrée : une string (ex. "Je suis une phrase de test. Moi aussi.") 
	- en sortie : une string contenant les relations de dépendance pour cette phrase : 
		. chaque relation se termine par '\n'
		. les relations pour les phrases de l'input sont séparées par des lignes vides."""
	string = bytes(string, "utf-8")
	p = subprocess.Popen(["java","-Xmx2g","-cp","/home/gu/Téléchargements/stanford-parser-full-2017-06-09/*:",
		"edu.stanford.nlp.parser.nndep.DependencyParser",
		"-model",
		"/home/gu/Téléchargements/stanford-french-corenlp-2017-06-09-models/edu/stanford/nlp/models/parser/nndep/UD_French.gz",
		"-tagger.model",
		"/home/gu/Téléchargements/stanford-french-corenlp-2017-06-09-models/edu/stanford/nlp/models/pos-tagger/french/french-ud.tagger",
		"-textFile","-"], stdin=subprocess.PIPE,stdout=subprocess.PIPE)
	parse_stdout = p.communicate(input=string)[0]
	return parse_stdout.decode("utf-8").strip()


def get_elex_mini(fichier,enc):
	"""
		Extraire d'un fichier un lexique réduit elex et modifié pour rajouter un trait +- humain(lefff)
		- prend en entrée : le fichier et son encodage
		- renvoit en sortie : le lexique au format dictionnaire python
	"""
	elex = defaultdict(list)
	with codecs.open(fichier,"r",encoding=enc) as elex_file:
		for line in elex_file:
			line = line.strip()
			data = line.split("\t")
			# print(len(data),data)
			if len(data) == 9:
				elex[data[0]].append([data[3],data[6]])
			elif len(data) == 10:
				elex[data[0]].append([data[4],data[7]])
	return elex


def human_ambig(token,elex):
	"""
		Tester si un mot peut avoir un sens grivois s'il est associé à un 
		mot dont le sens a des traits + humain
		(cf modification du elex mini)
		- prend en entrée : le mot et le lexique elex mini (dict)
		- renvoit en sortie : 'True' si c'est le cas, 'False' sinon

	"""
	entrees = elex[token]
	for e in entrees:
		# print(e)
		if "griv" in e[0]:
			cas = re.search("(Obj[de|à]|Poss).*@hum",e[0])
			if cas:
				return True
			else:
				return False

def humain_trait(token,elex):
	"""
		Tester si un mot a au moins un sens impliquant un trait + humain
			- prend en entrée : le mot et le lexique elex mini (dict)
			- renvoit en sortie : 'True' si c'est le cas, 'False' sinon

	"""
	entrees = elex[token]
	for e in entrees:
		# print("e0",e[0])
		if "pred" in e[0] or "poss":
			cas = re.search("@hum",e[0])
			if cas:
				return True
			else:
				return False



def separer_phrases(output):
	"""
		Séparer les phrases dans l'output du parseur de Stanford.
		- prend en entrée : l'output du parser
		- renvoit en sortie : une liste de phrases parsées.
	"""
	sents, tmp = [],[]
	output = output.split("\n")
	for rel in output[:-1]:
		if rel != "":
			# print(rel,"yy")
			tmp.append(rel)
		else:
			# print("---")
			sents.append(tmp)
			tmp = []
	tmp.append(output[-1])
	sents.append(tmp)
	return sents

def verif_semantique(phrases,lexique_griv,lexique_ambig):
	"""
		[Evaluation provisoire]
		Attribuer un score de grivoiserie à des phrases selon le nombre de mots grivois
		qu'elles contiennent : 
		- 2 points par mot grivois
		- 1 point par mot ambigu

		- prend en entrée : la phrase et les lexiques 
		- renvoit en sortie : un classement des phrases selon leur score de grivoiserie, 
			s'il y en a, 'None' sinon. (liste ordonnée de tuples)

	"""
	evals_griv, evals_ambig = [],[]
	for phrase in phrases:
		griv = 0
		tokens = phrase[:-1].split()
		for token in tokens:
			if token in lexique_griv:
				griv += 2
			elif token in lexique_ambig:
				griv += 1
		if griv > 0:
			score = (phrase,griv)
			evals_griv.append(score)
	if len(evals_griv) > 0:
		# return sorted(evals_griv, key=lambda tup: tup[1])[0][0]
		classement = [x[0] for x in sorted(evals_griv, key=lambda tup: tup[1],reverse=True) if x[1] > 0]
		return classement
	else:
		return None



def traits_humains(phrases,lexique):
	"""
		Vérifier la réalisation des phénomènes d'accord dans les cas des structures de
		complément du nom résolvant une ambiguité de grivoiserie qui repose sur un trait
		+hum (ex. : "la voûte des reins", "la chatte de la voisine", etc.)

		- prend en entrée : des phrases à tester et un lexique type elex mini
		- renvoit en sortie : les phrases sans erreur dans la réalisation des phénomènes
			d'accord (genre et nombre dans le cas test)
	"""
	text = "\n".join(phrases)
	parsed_text = stanford_nnparse(text)	
	parsed_sentences = separer_phrases(parsed_text)
	valables = []
	for ps in parsed_sentences:
		erreurs = 0
		for relation in ps:
			pat = "(?P<rel>[\w]+)\((?P<head>\w+).*, (?P<dep>[\w\.]+).*\)"
			m = re.match(pat,relation)
			if m:
				rel,head,dep = m.group("rel"),m.group("head"),m.group("dep")
				if human_ambig(head,lexique) == True and humain_trait(dep,lexique) == True:
					if rel in ["nmod"]:
						morpho_head = [m[1] for m in lexique[head]]
						morpho_dep = [m[1] for m in lexique[dep]]
						nombre_s_head = ["s" for m in morpho_head if "s" in m]
						nombre_p_head = ["p" for m in morpho_head if "p" in m]
						nombre_head = list(set(nombre_s_head + nombre_p_head))
						morpho_dep = [m[1] for m in lexique[dep]]
						morpho_dep = [m[1] for m in lexique[dep]]
						nombre_s_dep = ["s" for m in morpho_dep if "s" in m]
						nombre_p_dep = ["p" for m in morpho_dep if "p" in m]
						nombre_dep = list(set(nombre_s_dep + nombre_p_dep))
						if nombre_head[0] == "s" and nombre_dep[0] == "p":
							erreurs += 1
						else:
							# print("ok")
							continue
		# print("nb err",erreurs)
		if erreurs == 0:
			valables.append(phrases[parsed_sentences.index(ps)])
			
	return valables			