#/usr/bin/python3
#coding: utf-8

from generation import *
from verif1 import *
from grivoiserie import *
import subprocess


def patrons_successifs(phrase):
	"""
		Tester de manière successive plusieurs patrons de permutations sur une phrase input
		- prend en entrée : la phrase input (chaîne de caractères)
		- renvoit en sortie : une liste de contrepets trouvés pour la phrase avec l'ensemble
			des patrons implémentés

	"""
	if check_reec(phrase,reec_stanford) == False:
		print("\nL'input '{}' n'est pas en accord avec les règles de réécritures disponibles.\n Il n'est pas possible de le traiter, désolé.".format(phrase))
		return None
	else:
		patrons = [[permut0],[permut1],[permut2],[permut3],[permut4],[permut5],[permut6],[permut7],[permut8],[permut9],[permut10],[permut11],[permut12],[permut13],[permut14],[permut15]]
		stack = []
		for p in patrons:
			ok = contrepeterie(phrase,p)
			if ok == None:
				continue
			else:
				stack.extend(ok)
		print("\n\n#####################################\n\n")
		if stack:
			print("\nVoici le(s) contrepet(s) générés pour '{}' :\n({} patrons testés)\n".format(phrase,len(patrons)))
			[print(s) for s in stack]
		else:
			print("\nAucun contrepet n'a été trouvé pour '{}' avec les patrons modélisés.\n({} patrons testés)\n".format(phrase,len(patrons)))
		print("\n\n")
		return stack


# Ensemble de phrases utilisées pour l'évaluation du prototype
phrases_test = ["Ce n'est pas avec la branche qu'on fait des boulettes. ",
"Avez-vous entendu parler de ces mites qui courent sur les biches ? ",
"Appréciez le tout de mon cru. ",
"Avoir des cheveux ne vous empêche pas de nier. ",
"Bernard Pivot en a vu défiler des bouquins sur la deux. ",
"Beethoven détestait les sons courts. ",
"Allons ma fille essuie la vite et bien. ",
"À Wimbledon le juge de touche s'est fait acculer derrière Sanchez. ",
"A vouloir aller plus vite que le son vous risquez de vous briser la nuque. ",
"En voyant les nippons la Chine se souleva. ",
"Ce couvent de femmes a été fondé par les Saluces. ",
"Apprendre à calculer en cent leçons. ",
"Ce gant m'empêche de broder! ",
"Boude pas c'est pas ton genre ! ",
"Admirez donc l'écaille de ces moules ! ",
"Ici on peut voir un vieux plan de Gap. ",
"Achète que je rie ! ",
"Allons les filles ne cousez pas les robes ! ",
"Ce pignon a royale mine. ",
"Auberge de Vendée. ",
"Ça pue dans le car. ",
"Visiter le salon des vins ? ",
"Ce jeune homme a la mine piteuse. ",
"Que j'envie votre brasse ! ",
"Au Zambèze les filles sont belles et gentilles. ",
"A quoi bon me pousser pour que je vous trompe? ",
"Ce beau maillot excitait les foules. ",
"Ce qui me plaît quand je dîne est la purée. ",
"Adélaïde rue de La Paix. ",
"Dans ce clip il aime les sons. ",
"Vous chantez quand je vous laisse ? ",
"Assez de disputes tendues ! ",
"A l'Armée le lieutenant veut défiler et le général m'engueule. ",
"Ce camp a été victime d'un coup de semonce. ",
"Brigitte aime les vertes plages. ",
"Adjudant faites bisser l'appel ! ",
"Avez vous vu le bond de la crue. ",
"Après de pareils faits vous pouvez vous permettre  . ",
"Ah ma soeur vous avez bêché trois allées ! ",
"En voyant la Chine la jeune fille est envahie par une étrange pâleur. ",
"Après un apéritif les penseurs aiment diner. ",
"Ce que votre plante me fait ! ",
"Attention aux pannes de micro ! ",
"Aimer le blanc est une histoire de goût. ",
"Ca sent la frite de Malbat !"]

# Exemples de phrases à entrer en input
phrase1 = "Madame ce que votre plante me fait !" # permut7
phrase2 = "Ici on peut voir un vieux plan de Gap." # permut6
phrase3 = "La route des vins." # permut0
phrase4 = "Le sac des lapins." # permut1
phrase5 = "Vous avez le choix dans la date." #permut6
phrase6 = "Après une fluxion elle a perdu sa soeur." #permut8
phrase7 = "Mouiller les fiches." #permut2
phrase8 = "Le fond de la colle." #permut0
phrase9 = "Aimer le blanc est une histoire de goût." #permut6
phrase10 = "Beethoven détestait les sons courts." #permut0
phrase11 = "Un art de décaler les sons."
phrase12 = "En voyant les nippons la Chine se souleva."#permut10
phrase13 = "Avez vous vu le bond de la crue ?" #permut6
phrase14 = "Couper les nouilles au sécateur." # permut9
phrase15 = "Glisser dans la piscine."


# Traiter une phrase entrée par l'utilisateur
phrase = ""
while phrase != "stop":
	phrase = input("\nEntrez une phrase, ou 'stop' pour quitter.\n")
	stack = patrons_successifs(phrase)
	print("\nVérification sémantique de la grivoiserie...\nIl reste (en ordre décroissant si plusieurs contrepets) :\n")
	[print(x) for x in verif_semantique(stack,lexique_griv,lexique_ambig)]
	print("\n\n")
if phrase == 'stop':
	print("Merci d'avoir testé ce prototype ! ")


# resultats = defaultdict()
# for phrase in phrases_test:
# 	stack = patrons_successifs(phrase)
# 	# stack_grivois = verif_semantique(stack,lexique_griv,lexique_ambig)
# 	# if stack_grivois is not None and len(stack_grivois) > 0:
# 		# resultats[phrase] = stack_grivois
# 	resultats[phrase] = (len(stack),stack)
# 		# else: 
# 		# continue




# print(len(stack), len(resultats))


"""
# Exemple de cas où la sémantique implique des restrictions supplémentaire : 

# -> partie du corps au singulier + cdn à trait humain : 
# 	l'exemple n°2 (Un vieux plan de Gap <--> Un vieux gland de pape)

elex_mini = get_elex_mini("mini.elex","utf-8")
print("Troisième vérification...\nIl reste : \n")
[print(x) for x in traits_humains(verif_semantique(stack,lexique_griv,lexique_ambig),elex_mini)]

"""