#!/usr/bin/perl -w
################################################################################
# Tk-EuroConvert
# Convertisseur d'euro graphique
# Ralis paar Raphy Stoller <raphy@alpinux.net>
################################################################################
# Declaration de variables
################################################################################
use Tk;
use Tk::ErrorDialog;
use Tk::Dialog;
use strict;
################################################################################
# Enplacement des fichiers d'infos
################################################################################
my $gnu ="copying.txt";
my $thanks ="thanks.txt"; 
################################################################################
# Valeur de l'euro
################################################################################
my $euro_v_fr = "6.55957"; # Francs fr
my $euro_v_fb = "40.3399"; # Francs be
my $euro_v_de = "1.95583"; # Mark de
my $euro_v_es = "166.386"; # Pesetas
my $euro_v_it = "1936.27"; # Lires
my $euro_v_po = "200.482"; # Escudos po
my $euro_v_ne = "2.20371"; # Florin ne
my $euro_v_fi = "5.94573"; # Mark fi
my $euro_v_au = "13.7603"; # Shilling au
my $euro_v_ir = "0.787564"; # Livre ir
my $euro_v_lux ="40.3399"; # Francs Lux
my $euro_v_drakm = "340.75"; # Drachme
################################################################################
# FUTUR
################################################################################
my $euro_v_su = ""; # Couronnes su
my $euro_v_da = ""; # Coronnes da
my $euro_v_no = ""; # Couronnes no
my $euro_v_ls = ""; # livres sterlling
my $euro_v_ch = ""; # Francs CH
#
my $euro_v_us = ""; # dollars US
my $euro_v_ca = ""; # dollars ca
my $euro_v_yen = ""; # Yen
################################################################################
# FENETRE PRINCIPAL Tk-Euroconvert
################################################################################
my $mawin = MainWindow->new;
$mawin->title("Tk-EuroConvert");
$mawin->maxsize (qw(420 250));
$mawin->minsize (qw(340 200));
################################################################################
# MENU Tk-Euroconvert
################################################################################
my $menubar = $mawin -> Frame(
			      -relief => 'raised',
			      -borderwidth => 2
			     )->pack(-fill=>'x');
################################################################################
# Menu Fichier Gnral
################################################################################
my $menu_Fichier = $menubar -> Menubutton(-text =>'Menu',
					  -underline => 0,
					  -tearoff=> 0);
$menu_Fichier -> command(
			 -underline=>0,
			 -label=>'A propos de ...',
			 -command=> \&cb_About);
$menu_Fichier -> command(
			 -underline=>0,
			 -label=>'Remerciements',
			 -command=> \&cb_thanks);
$menu_Fichier -> command(
			 -underline=>0,
			 -label=>'License',
			 -command=> \&cb_license);
$menu_Fichier -> command(
			 -underline=>0,
			 -label=>'Quitter',
			 -command=> \&cb_Quitter,
			 -accelerator=>'Ctrl+q');
################################################################################
# Menu Changement d'unit
################################################################################
my $menu_convert = $menubar -> Menubutton (-text=>'Changement d\'unit',
					   -underline=>0,
					   -tearoff=>0);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Francs Fr',
			 -command=> \&cb_cv_fr);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Francs Fb',
			 -command=> \&cb_cv_fb_eu);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Francs Lux',
			 -command=> \&cb_cv_lux);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Mark De',
			 -command=> \&cb_cv_de);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Pesetas Es',
			 -command=> \&cb_cv_es);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Lires It',
			 -command=> \&cb_cv_it);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Escudos Po',
			 -command=> \&cb_cv_po);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Florin Ne',
			 -command=> \&cb_cv_ne);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Mark Fi',
			 -command=> \&cb_cv_fi);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Shilling Au',
			 -command=> \&cb_cv_au);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Livres Ir',
			 -command=> \&cb_cv_ir);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Drachme',
			 -command=> \&cb_cv_drakm);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Couronne Su',
			 -command=> \&cb_cv_su);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Couronne Da',
			 -command=> \&cb_cv_da);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Couronne No',
			 -command=> \&cb_cv_no);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Livres Sterling',
			 -command=> \&cb_cv_ls);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Dollar Us',
			 -command=> \&cb_cv_us);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Dollar Ca',
			 -command=> \&cb_cv_ca);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Yen',
			 -command=> \&cb_cv_yen);
$menu_convert -> command(
			 -underline=>0,
			 -label=>'Francs suisses',
			 -command=> \&cb_cv_ch);

################################################################################
# GESTION DES RACOURCIS CLAVIER
################################################################################
$mawin->bind('<Control-q>'=> \&cb_Quitter);
################################################################################
#  FRAME
################################################################################
my $cadre0 = $mawin -> Frame(-borderwidth=>2,
			     -relief=>'groove') -> pack(-padx=>10,-pady=>10);
my $gfram = $cadre0 ->Frame(-borderwidth=>2,
			    -relief=>'groove') ->pack(-padx=>10, -pady=>10);
my $ffram = $cadre0 ->Frame(-borderwidth=>2,
			    -relief=>'groove') ->pack(-padx=>10, -pady=>10);
my $cadre1 = $ffram -> Frame(-borderwidth=>2) -> pack(-side=>'right');
my $cadre2 = $ffram -> Frame(-borderwidth=>2) -> pack(-side=>'right');
my $cadre3 = $gfram -> Frame(-borderwidth=>2) -> pack(-side=>'left');
my $cadre4 = $gfram -> Frame(-borderwidth=>2) -> pack(-side=>'left');
################################################################################
# WIDGET
################################################################################
my $lbl0 = $cadre2 -> Label(-text=>'Euro :',
			    -foreground=>'blue') -> pack();
my $fentry = $cadre1 -> Entry(-width=>'30', 
			      -background=>'white',
			      -foreground=>'blue') -> pack();
my $lbl2 = $cadre2 -> Label(-text=>'Resultat en Francs Fr :',
			    -foreground=>'blue') -> pack();
my $lbl_result_eu = $cadre1 -> Label(-text=>'',
				     -borderwidth=>2,
				     -relief=>'groove',
				     -background=>'white',
				     -foreground=>'blue',
				     -width=>'30') -> pack();
my $but_an = $cadre2 -> Button(-text=>'Rinitialiser',
			       -command=> \&cb_rein_fr_eu) ->pack(-side=>'left');
my $but_ok = $cadre1 -> Button(-text=>'Convertir',
			       -command=> \&cb_cv_fr_eu) ->pack(-side=>'right');
my $lbl1 = $cadre3 -> Label(-text=>'Francs Fr :',
			    -foreground=>'blue') -> pack();
my $eentry = $cadre4 -> Entry(-width=>'30',
			      -background=>'white',
			      -foreground=>'blue') -> pack();
my $lbl4 = $cadre3 -> Label(-text=>'Rsultat en Euro :',
			    -foreground=>'blue') -> pack();
my $lbl_result_fr = $cadre4 -> Label(-text=>'',
				     -borderwidth=>2,
				     -relief=>'groove',
				     -background=>'white',
				     -foreground=>'blue',
				    -width=>'30') -> pack();
my $but_an0 = $cadre3 -> Button(-text=>'Rinitialiser',
				-command=> \&cb_rein_eu_fr) ->pack(-side=>'left');
my $but_ok0 = $cadre4 -> Button(-text=>'Convertir',
				-command=> \&cb_cv_eu_fr)->pack(-side=>'right');
################################################################################
# BIND
################################################################################
$fentry -> bind ('' => \&cb_cv_fr);
$eentry -> bind ('' => \&cb_cv_eu);
################################################################################
# AFFICHAGE
################################################################################
$menu_Fichier -> pack (-side=>'left');
$menu_convert -> pack (-side=>'left');
$mawin->update;
MainLoop;
################################################################################
# CALL BACK
################################################################################
# Francs Fr
################################################################################
sub cb_cv_fr_eu{
  my $franc_fr = $fentry -> get();
  if ($franc_fr == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_eu = $franc_fr * $euro_v_fr;
    my $around = sprintf ("%.2f\n", $result_eu);
    chomp $around;
    $lbl_result_eu -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;
  }
}
sub cb_rein_fr_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
}
sub cb_cv_eu_fr{
  my $eu = $eentry -> get();
  if ($eu == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_fr = $eu / $euro_v_fr;
    my $around = sprintf ("%.2f\n", $result_fr);
    chomp $around;
    $lbl_result_fr -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;
  }
}
sub cb_rein_eu_fr{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
################################################################################
# Convertion de francs belges
################################################################################
sub cb_cv_fb_eu{
  # On rinitialise tout
  cb_rein_fb_eu();
  cb_rein_eu_fb();
  $lbl2 -> configure (-text=>'Rsultat en Francs Be');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_fb_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_fb_eu0);
  $lbl1 -> configure (-text=>'Francs Be :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_fb);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_fb);
  $mawin->update;
}
sub cb_rein_fb_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
}
sub cb_cv_fb_eu0{
  my $franc_fb = $fentry -> get();
  if ($franc_fb == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_eu = $franc_fb * $euro_v_fb;
    my $around = sprintf ("%.2f\n", $result_eu);
    chomp $around;
    $lbl_result_eu -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;
  }
}
sub cb_rein_eu_fb{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
sub cb_cv_eu_fb{
  my $eu = $eentry -> get();
  if ($eu == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_fb = $eu / $euro_v_fb;
    my $around = sprintf("%.2f\n", $result_fb);
    chomp $around;
    $lbl_result_fr -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;
  }
}
################################################################################
# Francs Lux
################################################################################
sub cb_cv_lux{
  # On rinitialise tout
  cb_rein_lux_eu();
  cb_rein_eu_lux();
  $lbl2 -> configure (-text=>'Rsultat en Francs Lux');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_lux_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_lux_eu);
  $lbl1 -> configure (-text=>'Francs Lux :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_lux);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_lux);
  $mawin->update;
}
sub cb_cv_lux_eu{
  my $franc_lux = $fentry -> get();
  if ($franc_lux == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_eu = $franc_lux * $euro_v_lux;
    my $around = sprintf ("%.2f\n", $result_eu);
    chomp $around;
    $lbl_result_eu -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;
  }
}
sub cb_rein_lux_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
}
sub cb_cv_eu_lux{
  my $eu = $eentry -> get();
  if ($eu == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_lux = $eu / $euro_v_lux;
    my $around = sprintf("%.2f\n", $result_lux);
    chomp $around;
    $lbl_result_fr -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;
  }
}
sub cb_rein_eu_lux{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
################################################################################
# Francs franais
################################################################################
sub cb_cv_fr{
  # On rinitialse tout
  cb_rein_fr_eu();
  cb_rein_eu_fr();
  $lbl2 -> configure (-text=>'Rsultat en Francs Fr');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_fr_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_fr_eu); 
  $lbl1 -> configure (-text=>'Francs Fr :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_fr);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_fr);
  $mawin->update;
}
################################################################################
# Mark de
################################################################################
sub cb_cv_de{
  # On rinitialise tout
  cb_rein_de_eu();
  cb_rein_eu_de();
  $lbl2 -> configure (-text=>'Rsultat en Mark De :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_de_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_de_eu);
  $lbl1 -> configure (-text=>'Mark De :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_de);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_de);
  $mawin -> update;
}
sub cb_cv_de_eu{
  my $mark_de = $fentry -> get();
  if ($mark_de == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else {
    my $result_eu = $mark_de * $euro_v_de;
    my $around = sprintf("%.2f\n", $result_eu);
    chomp $around;
    $lbl_result_eu -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin->update; 
  }
}
sub cb_rein_de_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
sub cb_rein_eu_de{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
sub cb_cv_eu_de{
  my $eu = $eentry -> get();
  if ($eu == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_de = $eu / $euro_v_de;
    my $around = sprintf("%.2f\n", $result_de);
    chomp $around;
    $lbl_result_fr -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;
  }
}
################################################################################
# Pesetas Es
################################################################################
sub cb_cv_es{
  # On rinitialise tout
  cb_rein_es_eu();
  cb_rein_eu_es();
  $lbl2 -> configure (-text=>'Rsultat en Pesatas Es :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_es_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_es_eu);
  $lbl1 -> configure (-text=>'Pesetas Es :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_es);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_es);
  $mawin -> update;
}
sub cb_cv_es_eu{
  my $pesetas_es = $fentry -> get();
  if ($pesetas_es == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_eu = $pesetas_es * $euro_v_es;
    my $around = sprintf("%.2f\n", $result_eu);
    chomp $around;
    $lbl_result_eu -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin->update;
  }
}
sub cb_rein_es_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
sub cb_cv_eu_es{
  my $eu = $eentry -> get();
  if ($eu == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_es = $eu / $euro_v_es;
    my $around = sprintf("%.2f\n", $result_es);
    chomp $around;
    $lbl_result_fr -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;
  }
}
sub cb_rein_eu_es{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;  
}
################################################################################
# Lires It
################################################################################
sub cb_cv_it{
  # On rinitialise tout
  cb_rein_it_eu();
  cb_rein_eu_it();
  $lbl2 -> configure (-text=>'Rsultat en Lires It :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_it_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_it_eu);
  $lbl1 -> configure (-text=>'Lires It :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_it);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_it);
  $mawin ->update;
}
sub cb_cv_it_eu{
  my $lires_it = $fentry -> get();
  if ($lires_it == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_eu = $lires_it * $euro_v_it;
    my $around = sprintf("%.2f\n", $result_eu);
    chomp $around;
    $lbl_result_eu -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin->update;
  }
}
sub cb_rein_it_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
sub cb_cv_eu_it{
  my $eu = $eentry -> get();
  if ($eu == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_it = $eu / $euro_v_it;
    my $around = sprintf("%.2f\n", $result_it);
    chomp $around;    
    $lbl_result_fr -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;
  }
}
sub cb_rein_eu_it{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
################################################################################
# Escudos po
################################################################################
sub cb_cv_po{
  # On rinitialise tout
  cb_rein_po_eu();
  cb_rein_eu_po();
  $lbl2 -> configure (-text=>'Rsultat en Escudos Po :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_po_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_po_eu);
  $lbl1 -> configure (-text=>'Escudos Po :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_po);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_po);
  $mawin->update;
}
sub cb_cv_po_eu{
  my $escudos_po = $fentry -> get();
  if ($escudos_po == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_eu = $escudos_po * $euro_v_po;
    my $around = sprintf("%.2f\n", $result_eu);
    chomp $around;
    $lbl_result_eu -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin->update;
  }
}
sub cb_rein_po_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
sub cb_cv_eu_po{
  my $eu = $eentry -> get();
  if ($eu == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_po = $eu / $euro_v_po;
    my $around = sprintf("%.2f\n", $result_po);
    chomp $around;
    $lbl_result_fr -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;
  }
}
sub cb_rein_eu_po{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
################################################################################
# Florins Ne
################################################################################
sub cb_cv_ne{
  # On rinitialise tout
  cb_rein_ne_eu();
  cb_rein_eu_ne();
  $lbl2 -> configure (-text=>'Rsultat en Florins Ne :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_ne_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_ne_eu);
  $lbl1 -> configure (-text=>'Florins Ne :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_ne);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_ne);
  $mawin-> update;
}
sub cb_cv_ne_eu{
  my $florins_ne = $fentry -> get();
  if ($florins_ne == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_eu = $florins_ne * $euro_v_ne;
    my $around = sprintf("%.2f\n", $result_eu);
    chomp $around;
    $lbl_result_eu -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin->update;
  }
}
sub cb_rein_ne_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
sub cb_cv_eu_ne{
  my $eu = $eentry -> get();
  if ($eu == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_ne = $eu / $euro_v_ne;
    my $around = sprintf("%.2f\n", $result_ne);
    chomp $around;
    $lbl_result_fr -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;
  }
}
sub cb_rein_eu_ne{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
################################################################################
# Mark Fi
################################################################################
sub cb_cv_fi{
  # On rinitialise tout
  cb_rein_fi_eu();
  cb_rein_eu_fi();
  $lbl2 -> configure (-text=>'Rsultat en Mark Fi :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_fi_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_fi_eu);
  $lbl1 -> configure (-text=>'Mark Fi :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_fi);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_fi);
  $mawin->update;
}
sub cb_cv_fi_eu{
  my $mark_fi = $fentry -> get();
  if ($mark_fi == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_eu = $mark_fi * $euro_v_fi;
    my $around = sprintf("%.2f\n", $result_eu);
    chomp $around;
    $lbl_result_eu -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin->update;
  }
}
sub cb_rein_fi_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
sub cb_cv_eu_fi{
  my $eu = $eentry -> get();
  if ($eu == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_fi = $eu / $euro_v_fi;
    my $around = sprintf("%.2f\n", $result_fi);
    chomp $around;
    $lbl_result_fr -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;
  }
}
sub cb_rein_eu_fi{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
################################################################################
# Shilling Autrichien 
################################################################################
sub cb_cv_au{
  # On rinitialise tout
  cb_rein_au_eu();
  cb_rein_eu_au();
  $lbl2 -> configure (-text=>'Rsultat en Shilling Au :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_au_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_au_eu);
  $lbl1 -> configure (-text=>'Shilling Au :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_au);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_au);
  $mawin -> update;
}
sub cb_cv_au_eu{
  my $shilling_au = $fentry -> get();
  if ($shilling_au == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_eu = $shilling_au * $euro_v_au;
    my $around = sprintf("%.2f\n", $result_eu);
    chomp $around;
    $lbl_result_eu -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin->update;
  }
}
sub cb_rein_au_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
sub cb_cv_eu_au{
  my $eu = $eentry -> get();
  if ($eu == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -bitmap=>'info',
				 -width=>45,
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_au = $eu / $euro_v_au;
    my $around = sprintf("%.2f\n", $result_au);
    chomp $around;    
    $lbl_result_fr -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;
  }
}
sub cb_rein_eu_au{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
################################################################################
# Livres Ir
################################################################################
sub cb_cv_ir{
  # ON rinitialise tout
  cb_rein_ir_eu();
  cb_rein_eu_ir();
  $lbl2 -> configure (-text=>'Rsultat en Livres Ir :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_ir_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_ir_eu);
  $lbl1 -> configure (-text=>'Livres Ir :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_ir);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_ir);
  $mawin->update;
}
sub cb_cv_ir_eu{
  my $livres_ir = $fentry -> get();
  if ($livres_ir == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_eu = $livres_ir * $euro_v_ir;
    my $around = sprintf("%.2f\n", $result_eu);
    chomp $around;    
    $lbl_result_eu -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin->update;
  }
}
sub cb_rein_ir_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
sub cb_cv_eu_ir{
  my $eu = $eentry -> get();
  if ($eu == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_ir = $eu / $euro_v_ir;
    my $around = sprintf("%.2f\n", $result_ir);
    chomp $around;    
    $lbl_result_fr -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;
  }
}
sub cb_rein_eu_ir{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
################################################################################
# Couronnes Su
################################################################################
sub cb_cv_su{
  # On rinitialise tout
  cb_rein_su_eu();
  cb_rein_eu_su();
  $lbl2 -> configure (-text=>'Rsultat en Couronnes Su :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_su_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_su_eu);
  $lbl1 -> configure (-text=>'Couronnes Su :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_su);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_su);
  $mawin->update;
}
sub cb_cv_su_eu{
  # Message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_su non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # my $couronne_su = $fentry -> get();
  #if ($couronne_su == "A,Z[a,z]"){
  #  my $mess = $mawin -> Dialog (-borderwidth=>4,
	#			   -relief=>'groove',
	#			   -text=>"Vous devez entrer une valeur numrique !",
	#			   -justify=>'center',
	#			   -bitmap=>'info',
	#			   -title=>'Tk-Euroconvert',
	#			   -default_button=>'Ok',
	#			   -buttons=>[qw/Ok/]);
   # my $a = $mess -> Show(?-global?);
  #}
  #else{
  # my $result_eu = $couronne_su * $euro_v_su;
  #my $around = sprintf("%.2f\n", $result_eu);
  #chomp $around;        
  # $lbl_result_eu -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin->update;
  #}
}
sub cb_rein_su_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;  
}
sub cb_cv_eu_su{
  # Message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_su non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  #my $eu = $eentry -> get();
  #if ($eu == "A,Z[a,z]"){
  #  my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			   -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
   # my $a = $mess -> Show(?-global?);
  #}
  #else{
  #my $result_su = $eu / $euro_v_su;
  #my $around = sprintf("%.2f\n", $result_su);
  #chomp $around;        
  #$lbl_result_fr -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin -> update;
  #}  
}
sub cb_rein_eu_su{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;    
}
################################################################################
# Couronne Da
################################################################################
sub cb_cv_da{
  # On rinitialise tout
  cb_rein_da_eu();
  cb_rein_eu_da();
  $lbl2 -> configure (-text=>'Rsultat en Couronnes Da :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_da_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_da_eu);
  $lbl1 -> configure (-text=>'Couronnes Da :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_da);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_da);
  $mawin->update;
}
sub cb_cv_da_eu{
  # Message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_da non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # my $couronne_da = $fentry -> get();
  #if ($couronne_da == "A,Z[a,z]"){
  #  my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			   -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
  # my $a = $mess -> Show(?-global?);
  #}
  #else{
  # my $result_eu = $couronne_da * $euro_v_da;
  #my $around = sprintf("%.2f\n", $result_eu);
  #chomp $around;
  # $lbl_result_eu -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin->update;
  #}
}
sub cb_rein_da_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;  
}
sub cb_cv_eu_da{
  # Message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_da non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # Trouver le moyen d'interdir les caractres
  #my $eu = $eentry -> get();
  #if ($eu == "A,Z[a,z]"){
  #  my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			   -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
  # my $a = $mess -> Show(?-global?);
  #}
  #else{
  #my $result_da = $eu / $euro_v_da;
  #my $around = sprintf("%.2f\n", $result_da);
  #chomp $around;
  #$lbl_result_fr -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin -> update;  
  #}
}
sub cb_rein_eu_da{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
################################################################################
# Couronne No
################################################################################
sub cb_cv_no{
  # On rinitialise tout
  cb_rein_no_eu();
  cb_rein_eu_no();
  $lbl2 -> configure (-text=>'Rsultat en Couronnes No :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_no_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_no_eu);
  $lbl1 -> configure (-text=>'Couronnes No :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_no);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_no);
  $mawin->update;
}
sub cb_cv_no_eu{
  # Message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_no non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # Trouver le moyen d'interdir les caractres
  # my $couronne_no = $fentry -> get();
  #if ($eu == "A,Z[a,z]"){
  #  my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			   -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
  # my $a = $mess -> Show(?-global?);
  #}
  #else{
  # my $result_eu = $couronne_no * $euro_v_da;
  #my $around = sprintf("%.2f\n", $result_eu);
  #chomp $around;
  # $lbl_result_eu -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin->update;
  #}
}
sub cb_rein_no_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;  
}
sub cb_cv_eu_no{
  # message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_no non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # Trouver le moyen d'interdir les caractres
  #my $eu = $eentry -> get();
  #if ($eu == "A,Z[a,z]"){
  #  my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			   -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
  # my $a = $mess -> Show(?-global?);
  #}
  #else{
  #my $result_no = $eu / $euro_v_no;
  #my $around = sprintf("%.2f\n", $result_po);
  #chomp $around;
  #$lbl_result_fr -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin -> update;  
  #}
}
sub cb_rein_eu_no{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
################################################################################
# Livres Sterling
################################################################################
sub cb_cv_ls{
  # On rinitialise tout
  cb_rein_ls_eu();
  cb_rein_eu_ls();
  $lbl2 -> configure (-text=>'Rsultat en Livres Sterling :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_ls_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_ls_eu);
  $lbl1 -> configure (-text=>'Livres Sterling :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_ls);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_ls);
  $mawin->update;
}
sub cb_cv_ls_eu{
  # Message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_ls non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # Trouver le moyen d'interdir les caractres
  # my $livres_ls = $fentry -> get();
  #if ($livres_ls == "A,Z[a,z]"){
  #  my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			   -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
  # my $a = $mess -> Show(?-global?);
  #}
  #else{
  # my $result_eu = $livres_ls * $euro_v_ls;
  #my $around = sprintf("%.2f\n", $result_eu);
  #chomp $around;
  # $lbl_result_eu -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin->update;
  #}
}
sub cb_rein_ls_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;  
}
sub cb_cv_eu_ls{
  # message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_ls non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # Trouver le moyen d'interdir les caractres
  #my $eu = $eentry -> get();
  #if ($eu == "A,Z[a,z]"){
  #  my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			   -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
  # my $a = $mess -> Show(?-global?);
  #}
  #else{
  #my $result_ls = $eu / $euro_v_ls;
  #my $around = sprintf("%.2f\n", $result_ls);
  #chomp $around;
  #$lbl_result_fr -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin -> update;
  #}
}
sub cb_rein_eu_ls{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
################################################################################
# Dollar US
################################################################################
sub cb_cv_us{
  # On rinitialise tout
  cb_rein_us_eu();
  cb_rein_eu_us();
  $lbl2 -> configure (-text=>'Rsultat en Dollar Us :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_us_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_us_eu);
  $lbl1 -> configure (-text=>'Dollar Us :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_us);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_us);
  $mawin -> update;
}
sub cb_cv_us_eu{
  # Message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				-relief=>'groove',
				 -text=>"Variable euro_v_us non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # Trouver le moyen d'interdir les caractres
  # my $dolar_us = $fentry -> get();
  #if ($dolar_us == "A,Z[a,z]"){
  #  my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			   -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
  # my $a = $mess -> Show(?-global?);
  #}
  #else{
  # my $result_eu = $dollar_us * $euro_v_us;
  #my $around = sprintf("%.2f\n", $result_eu);
  #chomp $around;
  # $lbl_result_eu -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin->update;
  #}
}
sub cb_rein_us_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;  
}
sub cb_cv_eu_us{
  # Message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_us non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # Trouver le moyen d'interdir les caractres
  #my $eu = $eentry -> get();
  #if ($eu == "A,Z[a,z]"){
  #  my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			   -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
  # my $a = $mess -> Show(?-global?);
  #}
  #else{
  #my $result_us = $eu / $euro_v_us;
  #my $around = sprintf("%.2f\n", $result_us);
  #chomp $around;
  #$lbl_result_fr -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin -> update;
  #}  
}
sub cb_rein_eu_us{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
}
################################################################################
# Dolar Ca
################################################################################
sub cb_cv_ca{
  # On rinitialise tout
  cb_rein_ca_eu();
  cb_rein_eu_ca();
  $lbl2 -> configure (-text=>'Rsultat en Dollar Ca :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_ca_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_ca_eu);
  $lbl1 -> configure (-text=>'Dollar Ca :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_ca);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_ca);
  $mawin -> update;
}
sub cb_cv_ca_eu{
  # Message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_ca non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # Trouver le moyen d'interdir les caractres
  # my $dolar_ca = $fentry -> get();
  #if ($dolar_ca == "A,Z[a,z]"){
  #  my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			   -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
  # my $a = $mess -> Show(?-global?);
  #}
  #else{
  # my $result_eu = $dollar_ca * $euro_v_ca;
  #my $around = sprintf("%.2f\n", $result_eu);
  #chomp $around;
  # $lbl_result_eu -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin->update;
  #}
}
sub cb_rein_ca_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;  
}
sub cb_cv_eu_ca{
  # Message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_ca non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # Trouver le moyen d'interdir les caractres
  #my $eu = $eentry -> get();
  #if ($eu == "A,Z[a,z]"){
  #  my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			   -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
  # my $a = $mess -> Show(?-global?);
  #}
  #else{
  #my $result_ca = $eu / $euro_v_ca;
  #my $around = sprintf("%.2f\n", $result_ca);
  #chomp $around;
  #$lbl_result_fr -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin -> update;
  #}
}
sub cb_rein_eu_ca{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
} 
################################################################################
# Yen
################################################################################
sub cb_cv_yen{
  # On rinitialise tout
  cb_rein_yen_eu();
  cb_rein_eu_yen();
  $lbl2 -> configure (-text=>'Rsultat en Yen :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_yen_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_yen_eu);
  $lbl1 -> configure (-text=>'Yen :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_yen);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_yen);
  $mawin->update;
}
sub cb_cv_yen_eu{
  # Message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_yen non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # Trouver le moyen d'interdir les caractres
  # my $yen = $fentry -> get();
  #if ($yen == "A,Z[a,z]"){
  #  my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			   -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
  # my $a = $mess -> Show(?-global?);
  #}
  #else{
  # my $result_eu = $yen * $euro_v_yen;
  #my $around = sprintf("%.2f\n", $result_eu);
  #chomp $around;
  # $lbl_result_eu -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin->update;
  #}
}
sub cb_rein_yen_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;  
}
sub cb_cv_eu_yen{
  # Message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_yen non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # Trouver le moyen d'interdir les caractres
  #my $eu = $eentry -> get();
  #if ($eu == "A,Z[a,z]"){
  #  my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			   -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
  # my $a = $mess -> Show(?-global?);
  #}
  #else{
  #my $result_yen = $eu / $euro_v_yen;
  #my $around = sprintf("%.2f\n", $result_yen);
  #chomp $around;
  #$lbl_result_fr -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin -> update;
  #}
}
sub cb_rein_eu_yen{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
} 
################################################################################
# Drachme
################################################################################
sub cb_cv_drakm{
  # On rinitialise tout
  cb_rein_drakm_eu();
  cb_rein_eu_drakm();
  $lbl2 -> configure (-text=>'Rsultat en Drachme :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_drakm_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_drakm_eu);
  $lbl1 -> configure (-text=>'Drachme :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_drakm);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_drakm);
  $mawin->update;
}
sub cb_cv_drakm_eu{
  # Trouver le moyen d'interdir les caractres
  my $drakm = $fentry -> get();
  if ($drakm == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_eu = $drakm * $euro_v_drakm;
    my $around = sprintf("%.2f\n", $result_eu);
    chomp $around;
    $lbl_result_eu -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin->update;
  }
}
sub cb_rein_drakm_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;  
}
sub cb_cv_eu_drakm{
  my $eu = $eentry -> get();
  if ($eu == "A,Z[a,z]"){
    my $mess = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Vous devez entrer une valeur numrique !",
				 -justify=>'center',
				 -width=>45,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
    my $a = $mess -> Show();
  }
  else{
    my $result_drakm = $eu / $euro_v_drakm;
    my $around = sprintf("%.2f\n", $result_drakm);
    chomp $around;
    $lbl_result_fr -> configure (-text=>"$around",
				 -borderwidth=>2,
				 -relief=>'groove',
				 -background=>'white',
				 -foreground=>'blue',
				 -width=>'30',
				 -justify=>'left');
    $mawin -> update;  
  }
}
sub cb_rein_eu_drakm{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
} 
################################################################################
# Francs CH
################################################################################
sub cb_cv_ch{
  # On rinitialise tout
  cb_rein_ch_eu();
  cb_rein_eu_ch();
  $lbl2 -> configure (-text=>'Rsultat en Francs Ch :');
  $but_an -> configure (-text=>'Rinitialiser',
			-command=> \&cb_rein_ch_eu);
  $but_ok -> configure (-text=>'Convertir',
			-command=> \&cb_cv_ch_eu);
  $lbl1 -> configure (-text=>'Francs Ch :',
		      -foreground=>'blue');
  $but_an0 -> configure (-text=>'Rinitialiser',
			 -command=> \&cb_rein_eu_ch);
  $but_ok0 -> configure (-text=>'Convertir',
			 -command=> \&cb_cv_eu_ch);
  $mawin->update;
}
sub cb_cv_ch_eu{
  # Message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_ch non dfinie !",
				 -justify=>'center',
				 -width=>35,
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # Trouver le moyen d'interdir les caractres
  # my $ch = $fentry -> get();
  #if ($ch == "A,Z[a,z]"){
  # my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			    -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
  # my $a = $mess -> Show();
  #}
  #else{
  # my $result_eu = $ch * $euro_v_ch;
  #my $around = sprintf("%.2f\n", $result_eu);
  #chomp $around;
  # $lbl_result_eu -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin->update;
  #}
}
sub cb_rein_ch_eu{
  $lbl_result_eu -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;  
}
sub cb_cv_eu_ch{
  # Message provisoir
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Variable euro_v_ch non dfinie !",
				 -width=>35,
				 -justify=>'center',
				 -bitmap=>'info',
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]);
  my $aff = $mydial -> Show();
  ############################################################################
  # FUTUR
  ############################################################################
  # Trouver le moyen d'interdir les caractres
  #my $eu = $eentry -> get();
  #if ($eu == "A,Z[a,z]"){
  # my $mess = $mawin -> Dialog (-borderwidth=>4,
  #			   -relief=>'groove',
  #			   -text=>"Vous devez entrer une valeur numrique !",
  #			   -justify=>'center',
  #			    -bitmap=>'info',
  #			   -title=>'Tk-Euroconvert',
  #			   -default_button=>'Ok',
  #			   -buttons=>[qw/Ok/]);
  # my $a = $mess -> Show();
  #}
  #else{
  #my $result_ch = $eu / $euro_v_ch;
  #my $around = sprintf("%.2f\n", $result_ch);
  #chomp $around;
  #$lbl_result_fr -> configure (-text=>"$around",
  #			 -borderwidth=>2,
  #			 -relief=>'groove',
  #			 -background=>'white',
  #			 -foreground=>'blue',
  #			 -width=>'30',
  #			 -justify=>'left');
  # $mawin -> update;
  #}
}
sub cb_rein_eu_ch{
  $lbl_result_fr -> configure (-text=>'',
			       -borderwidth=>2,
			       -relief=>'groove',
			       -background=>'white',
			       -foreground=>'blue',
			       -width=>'30');
  $mawin -> update;
} 

################################################################################
# CALL BACK MENU 
################################################################################
# A propos de ...
sub cb_About{
  my $mydial = $mawin -> Dialog (-borderwidth=>4,
				 -relief=>'groove',
				 -text=>"Tk-Euroconvert by\nRaphy Stoller\nraphy\@alpinux.net\n\nhttp://www.alpinux.net\nhttp://www.raphy-stoller.org",
				 -justify=>'center',
				 -bitmap=>'info',
				 -width=>30,
				 -title=>'Tk-Euroconvert',
				 -default_button=>'Ok',
				 -buttons=>[qw/Ok/]); 
  my $aff = $mydial -> Show();
}
################################################################################
# Remerciements
################################################################################
sub cb_thanks{
  my $tks_win = MainWindow->new;
  $tks_win -> title("Remerciements");
  $tks_win -> minsize (qw(320 200));
  $tks_win->focusForce;
  my $frm00 = $tks_win -> Frame (-borderwidth => 4,
				 -relief => 'groove') -> pack(-padx=>10, -pady=>10, -fill=>'both', -expand=>'true');
  my $frm01 = $frm00 -> Frame (-borderwidth => 4,
			       -relief =>'groove') -> pack(-padx=>10, -pady=>10, -fill=>'both', -expand=>'true');
  my $texte = $frm01 ->Scrolled("Text", -background=>'white')->pack(-fill=>'both', -expand=>'true');
  open(FICH,"$thanks") or die ("impossible d'ouvrir $thanks !\n");
  while (<FICH>){
    $texte -> Insert("$_", 'end');
  }
}
################################################################################
# Quitter
################################################################################
sub cb_Quitter{
  my $mydial = $mawin -> Dialog( -borderwidth=>4,
				 -relief=>'groove',
				 -text=>'Voulez-vous vraiment quitter Tk-Euroconvert ?',
				 -justify=>'center',
				 -bitmap=>'question',
				 -title=>'Tk-Euroconvert',
				 -width=>30,
				 -default_button=>'Ok',
				 -buttons=>[qw(Ok Cancel)]);
  # Recupere le clic sur le bouton OK de la boite de dialog !!
  my $exit = $mydial -> Show();
  if ($exit eq 'Ok'){
    exit;
  }
  else{}
}
################################################################################
# License
################################################################################
sub cb_license{
  my $gnu_win = MainWindow->new;
  $gnu_win -> title("GNU - License");
  $gnu_win -> minsize (qw(320 200));
  $gnu_win->focusForce;
  my $frm00 = $gnu_win -> Frame (-borderwidth => 4,
				 -relief => 'groove') -> pack(-padx=>10, -pady=>10, -fill=>'both', -expand=>'true');
  my $frm01 = $frm00 -> Frame (-borderwidth => 4,
			       -relief =>'groove') -> pack(-padx=>10, -pady=>10, -fill=>'both', -expand=>'true');
  my $texte = $frm01 ->Scrolled("Text", -background=>'white')->pack(-fill=>'both', -expand=>'true');
  open(FICH,"$gnu") or die ("impossible d'ouvrir $gnu !\n");
  while (<FICH>){
    $texte -> Insert("$_", 'end');
  }
}
